/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.utils.ItemInfoHelper;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

@EMCMapper
public class BrewingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final Set<ItemInfo> allReagents = new HashSet<ItemInfo>();
    private static final Set<ItemInfo> allInputs = new HashSet<ItemInfo>();
    private static int totalConversions;
    private static int totalPotionItems;

    private static boolean mapAllReagents() {
        int conversionCount = PotionBrewing.f_43495_.size() + PotionBrewing.f_43494_.size();
        if (totalConversions == conversionCount) {
            return true;
        }
        allReagents.clear();
        BrewingMapper.addReagents(PotionBrewing.f_43495_);
        BrewingMapper.addReagents(PotionBrewing.f_43494_);
        totalConversions = conversionCount;
        return true;
    }

    private static <T extends ForgeRegistryEntry<T>> void addReagents(List<PotionBrewing.Mix<T>> conversions) {
        for (PotionBrewing.Mix<T> conversion : conversions) {
            for (ItemStack r : conversion.f_43533_.m_43908_()) {
                allReagents.add(ItemInfo.fromStack(r));
            }
        }
    }

    private static void mapAllInputs() {
        int count = PotionBrewing.f_43496_.size();
        if (totalPotionItems == count) {
            return;
        }
        allInputs.clear();
        HashSet<ItemInfo> inputs = new HashSet<ItemInfo>();
        for (Ingredient potionItem : PotionBrewing.f_43496_) {
            ItemStack[] matchingStacks = BrewingMapper.getMatchingStacks(potionItem);
            if (matchingStacks == null) continue;
            for (ItemStack input : matchingStacks) {
                inputs.add(ItemInfo.fromStack(input));
            }
        }
        for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
            for (ItemInfo input : inputs) {
                allInputs.add(ItemInfoHelper.makeWithPotion(input, potion));
            }
        }
        totalPotionItems = count;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, ReloadableServerResources serverResources, ResourceManager resourceManager) {
        boolean vanillaRetrieved = BrewingMapper.mapAllReagents();
        if (vanillaRetrieved) {
            BrewingMapper.mapAllInputs();
        }
        HashMap<AbstractNBTNSSTag, Integer> waterIngredients = new HashMap<AbstractNBTNSSTag, Integer>();
        waterIngredients.put(NSSItem.createItem((ItemLike)Items.f_42590_), 1);
        waterIngredients.put(NSSFluid.createTag((TagKey<Fluid>)FluidTags.f_13131_), 333);
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)), waterIngredients);
        HashSet canNotMap = new HashSet();
        int recipeCount = 0;
        List recipes = BrewingRecipeRegistry.getRecipes();
        for (IBrewingRecipe iBrewingRecipe : recipes) {
            if (iBrewingRecipe instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)iBrewingRecipe;
                ItemStack[] validInputs = BrewingMapper.getMatchingStacks(brewingRecipe.getInput());
                ItemStack[] validReagents = BrewingMapper.getMatchingStacks(brewingRecipe.getIngredient());
                if (validInputs == null || validReagents == null) continue;
                ItemStack output = brewingRecipe.getOutput();
                NSSItem nssOut = NSSItem.createItem(output);
                for (ItemStack validInput : validInputs) {
                    NSSItem nssInput = NSSItem.createItem(validInput);
                    for (ItemStack validReagent : validReagents) {
                        HashMap<NSSItem, Integer> ingredientsWithAmount = new HashMap<NSSItem, Integer>();
                        ingredientsWithAmount.put(nssInput, 3);
                        ingredientsWithAmount.put(NSSItem.createItem(validReagent), validReagent.m_41613_());
                        mapper.addConversion(3 * output.m_41613_(), (NormalizedSimpleStack)nssOut, ingredientsWithAmount);
                        ++recipeCount;
                    }
                }
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe) {
                if (!vanillaRetrieved) {
                    canNotMap.add(iBrewingRecipe.getClass());
                    continue;
                }
                for (ItemInfo inputInfo : allInputs) {
                    ItemStack validInput = inputInfo.createStack();
                    NSSItem nssInput = NSSItem.createItem(validInput);
                    for (ItemInfo reagentInfo : allReagents) {
                        ItemStack validReagent = reagentInfo.createStack();
                        ItemStack output = iBrewingRecipe.getOutput(validInput, validReagent);
                        if (output.m_41619_()) continue;
                        HashMap<NSSItem, Integer> ingredientsWithAmount = new HashMap<NSSItem, Integer>();
                        ingredientsWithAmount.put(nssInput, 3);
                        ingredientsWithAmount.put(NSSItem.createItem(validReagent), 1);
                        mapper.addConversion(3 * output.m_41613_(), (NormalizedSimpleStack)NSSItem.createItem(output), ingredientsWithAmount);
                        ++recipeCount;
                    }
                }
                continue;
            }
            canNotMap.add(iBrewingRecipe.getClass());
        }
        PECore.debugLog("BrewingMapper Statistics:", new Object[0]);
        PECore.debugLog("Found {} Brewing Recipes", recipeCount);
        for (Class clazz : canNotMap) {
            PECore.debugLog("Could not map Brewing Recipes with Type: {}", clazz.getName());
        }
    }

    @Override
    public String getName() {
        return "BrewingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Brewing Recipes";
    }

    @Nullable
    private static ItemStack[] getMatchingStacks(Ingredient ingredient) {
        try {
            return ingredient.m_43908_();
        }
        catch (Exception e) {
            return null;
        }
    }
}

